/**
 * Created by yang.sun_1 on 2015/11/18.
 */
appModule.controller('NoticeCtrl', ['$scope', 'api', '$timeout', 'utils', 'notices', 'pages', '$location', '$translate', 'log', function ($scope, api, $timeout, utils, notices, pages, $location, translate, log) {
    //返回到应用
    $scope.backToMain = function () {
        $location.url("/");
    };
    $scope.topicMaxLength = 30;
    $scope.summaryMaxLength = 50;
    $scope.accountSettingKey = "account_for_setting";
    $scope.lang = appModule.lang;
    $scope.setInputEditorCaretPosition = function ($event) {
        utils.setInputEditorCaretPosition($($event.currentTarget));
    };

    $scope.onInputCaretPositionKeyUp = function ($event) {
        utils.onInputCaretPositionKeyUp($($event.currentTarget));
    };

    $scope.openImageDialog = function (param, cb) {
        utils.openImageDialog(function (data) {
            if (!!cb) {
                cb(data);
            }
        });
    };

    $scope.fileUploadedListeners = [];

    $scope.onFileUploaded = function (args) {
        for (var i = $scope.fileUploadedListeners.length - 1; i >= 0; i--) {
            if ($scope.fileUploadedListeners[i].taskId == args[0]) {
                $scope.fileUploadedListeners[i].callback({
                    errorCode: 0,
                    data: args[1]
                });
                $scope.fileUploadedListeners.splice(i, 1);
                return;
            }
        }
    };

    $scope.saveDraft = function () {
        $scope.onDraftUpdate();
        if (!$scope.historyNoticesSelected) {
            utils.applyScope($scope, function () {
                $scope.selectedNotices = $scope.draftNotices;
            });
        }
    };

    $scope.deleteNotice = function (n, e) {
        if ($scope.isSendingNotice) {
            return;
        }
        if (e) {
            e.stopPropagation();
        }
        var option = {
            msg: translate.instant("notice.delete-confirm", {category: notices.getCategoryName(n.category)}),
            onConfirm: function () {
                if ($scope.selectedNotice && ((n.id && n.id == $scope.selectedNotice.id) || n.localId == $scope.selectedNotice.localId)) {
                    $scope.closeDetail();
                }
                api.deleteNotice(n, function () {
                    utils.applyScope($scope, function () {
                        var list = !!n.id ? $scope.historyNotices : $scope.draftNotices;
                        for (var i = list.length - 1; i > -1; i--) {
                            if (list[i] == n) {
                                list.splice(i, 1);
                                // if (!!n.id) {
                                //     $scope.cacheNotices[$scope.selectedAccount.id] = list;
                                // }
                                return;
                            }
                        }
                    });
                }, function (msg) {
                    if (msg) {
                        api.notifyError(msg);
                    }
                });
            },
            onCancel: null,
            isShowCancel: true
        };

        api.notifyError(option);

    };

    $scope.sendNotice = function (param) {

        utils.applyScope($scope, function () {
            $scope.onDraftUpdate();
        });

        var newNotice = notices.notice.create();
        //新创建的广播如果没有创建时间，将当前时间赋值为创建时间
        if (!param.created_at) {
            param.created_at = param.modified_at || Date.now();
        }
        notices.notice.convertFromData(newNotice, param);
        newNotice.creatorId = $scope.currentUser.userId;
        if ($scope.selectedAccount.id == newNotice.accountId) {//当前选择的是已发送列表并且当前选择的账号是此广播的账号
            utils.applyScope($scope, function () {
                $scope.historyNotices.unshift(newNotice);
                $scope.showEmpty = false;
            });
            if ($scope.historyNoticesSelected) {
                $scope.$broadcast("scrollToTop", $scope.historyNoticesId);
            } else {//当前选择的是草稿箱
                $scope.onDraftUpdate();
                utils.applyScope($scope, function () {
                    $scope.selectedNotices = $scope.draftNotices;
                });
            }
        }
    };

    $scope.userManage = function (e, account) {
        e.preventDefault();
        e.stopPropagation();
        account.isEdit = true;
        var el = e.currentTarget.parentElement.getElementsByTagName('input')[0];
        setTimeout(function () {
            el.focus();
        }, 0);

    };

    $scope.showPublishSuccess = function () {
        $scope.showSuccessMsg = true;
        $timeout(function () {
            $scope.showSuccessMsg = false;
        }, 2000);
    };

    $scope.showPublish = function (n, e, isCopy) {
        if (!$scope.selectedAccount) {
            return;
        }

        notices.saveSelectedAccount($scope.selectedAccount);
        var url = $scope.selectedAccount.category == 'bbs' ? 'publish.html' : $scope.selectedAccount.category == 'task' ? 'task_publish.html' : null;
        if (!url) {
            return;
        }
        var eventName = "publish";
        if (isCopy) {
            url += '?isCopy=1';
        }
        if (!!n) {
            notices.saveTempNotice(n);
        }
        if(!isCopy && $scope.selectedAccount.category == 'bbs'  && !n){
            eventName +='_'+new Date().getTime();
            url +='?'+new Date().getTime();
        }else{
            pages.fnCall("publishWindow", "onClose", {saveDraft: true}, function () {
            });
        }

        $timeout(function () {
            pages.openModalDialog(url, eventName, 900, 670, $scope, {
                modal: false,
                behaviorIfSCClose: 4,
                enableDrag: true,
                macResolution: {width: 900, height: 670},
                showCloseButton: true,
                showMinimalButton: true,
                showFullScreenButton: true
            });
            $scope.closeDetail();
        }, 50);
    };

    $scope.onEdit = function (n, e) {
        if (n.id) {
            return;
        }
        $scope.showPublish(n, e);
    };

    $scope.copyNotice = function (notice, e) {
        $scope.showPublish(notice, e, true);
    };

    $scope.isUnableToSend = function (n) {
        var result = !n || n.id || !n.topic || n.topic.length > $scope.topicMaxLength || (n.summary && n.summary.length > $scope.summaryMaxLength) || !n.content || !n.cover || n.sections.length == 0;
        return result;
    };

    $scope.publishNotice = function (n, e) {
        e.stopPropagation();
        if ($scope.isUnableToSend(n)) {
            return;
        }
        var option = {
            msg: translate.instant("publish.alert.send-confirm"),
            onConfirm: function () {
                if (n == $scope.selectedNotice) {
                    $scope.isSendingNotice = true;
                    $scope.startUploadLocalImages(n);
                }
            },
            onCancel: null,
            isShowCancel: true
        };
        api.notifyError(option);
    };

    $scope.startUploadLocalImages = function (n) {
        var contentHtml = n.content;
        notices.uploadEditorImages(contentHtml, function (code, message, html) {
            utils.applyScope($scope, function () {
                $scope.onLocalImagesUploaded({
                    "errorCode": code,
                    "errorMessage": message,
                    "data": html
                });
            });
        });
    };

    $scope.onLocalImagesUploaded = function (args) {
        if (args.errorCode !== 0) {
            log.logInfo("upload local image failed:" + args.errorMessage);
            api.notifyError(translate.instant("publish.alert.upload-image-failed"));
            return;
        }
        $scope.selectedNotice.type = "";
        $scope.selectedNotice.content = args.data;
        var promise = notices.notice.convertToData($scope.selectedNotice);
        promise.then(function (data) {
            if (!data.id) {
                notices.saveNoticeDraft($scope.selectedNotice);
            }
            delete data.id;//删除转发的公告id
            api.sendNotice(data, function (result) {
                utils.applyScope($scope, function () {
                    $scope.isSendingNotice = false;
                    notices.removeNoticeDraft($scope.selectedNotice);
                    $scope.closeDetail();
                    $scope.sendNotice(result);
                });
            }, function (msg) {
                utils.applyScope($scope, function () {
                    $scope.isSendingNotice = false;
                    pages.fnCall("notice", "saveDraft", "", function () {
                    });
                    if (msg) {
                        api.notifyError(msg);
                    } else {
                        api.notifyError(translate.instant("publish.alert.send-failed"));
                    }
                });
            });
        });
    };

    //------------------------------任务--------------------------------//

    $scope.canCancelTask = function (task) {
        return task.id && !task.is_close;
    };

    $scope.cancelTask = function (task, e) {
        if (e) {
            e.stopPropagation();
        }

        if ($scope.canCancelTask(task)) {
            var option = {
                msg: translate.instant("notice.cancel-confirm", {category: notices.getCategoryName(task.category)}),
                onConfirm: function () {
                    api.cancelTask(task.id, function () {
                        var list = $scope.historyNotices;
                        for (var i = list.length - 1; i > -1; i--) {
                            if (list[i].id == task.id) {
                                utils.applyScope($scope, function () {
                                    $scope.historyNotices[i].is_close = true;
                                });
                                break;
                            }
                        }
                        utils.applyScope($scope, function () {
                            $scope.closeDetail();
                        });
                    }, function (msg) {
                        utils.applyScope($scope, function () {
                            $scope.closeDetail();
                            api.notifyError(msg);
                        });
                    });
                },
                onCancel: null,
                isShowCancel: true
            };

            api.notifyError(option);

        }
    };


    $scope.convertBadgeNumber = function (num) {
        return utils.convertBadgeNumber(num);
    };
    //-----------------------------------------------------------------//

    //-------------------------广播列表----------------------------------//
    $scope.ITEM_PER_PAGE = 20;
    $scope.historyNoticesSelected = true;
    $scope.historyNotices = [];
    $scope.historyNoticesId = "histories";
    $scope.draftNoticesId = "drafts";
    $scope.isLoadingNotice = false;
    $scope.isSendingNotice = false;

    $scope.onDraftUpdate = function () {
        if (!!$scope.selectedAccount) {
            $scope.draftNotices = notices.getDrafts($scope.currentUser.userId, $scope.selectedAccount.id);
        }
    };

    $scope.getPreAuditCount = function (noticeIds) {
        api.getTaskPreAuditNumber(null, noticeIds, function (data) {
            var noticePreAuditNumbers = data.bbs_num;
            if (noticePreAuditNumbers) {
                utils.applyScope($scope, function () {
                    $scope.historyNotices.forEach(function (n) {
                        if (noticePreAuditNumbers[n.id] != undefined) {
                            n.preAuditCount = noticePreAuditNumbers[n.id];
                        }
                    });
                });
            }
        }, function (msg) {
            log.logInfo('fail to load pre audit count: ' + msg);
        });
    }

    $scope.getNotices = function (isNew) {
        if (!$scope.isLoadingNotice) {
            utils.applyScope($scope, function () {
                $scope.isLoadingNotice = true;
            });
            var lastNoticeId = $scope.historyNotices.length > 0 ? (!!isNew ? $scope.historyNotices[0].id : $scope.historyNotices[$scope.historyNotices.length - 1].id) : 0;
            var accountId = $scope.selectedAccount.id;
            var criteria = {
                lastNoticeId: lastNoticeId,
                isNew: isNew
            };
            if ($scope.selectedAccount.searchText) {
                criteria.keyword = $scope.selectedAccount.searchText;
                if (!isNew) {
                    criteria.start = $scope.historyNotices.length + 1;
                }
            } else {
                if ($scope.selectedAccount.timeRange && $scope.selectedAccount.timeRange.value) {
                    var curTimestamp = Date.now();
                    criteria.startTime = curTimestamp - $scope.selectedAccount.timeRange.value;
                }
                if ($scope.selectedAccount.category && $scope.selectedAccount.category.type && $scope.selectedAccount.category.type != 'all') {
                    criteria.category = $scope.selectedAccount.category.type;
                }
                if ($scope.selectedAccount.selectedEditor && $scope.selectedAccount.selectedEditor.id != -1) {
                    criteria.editorId = $scope.selectedAccount.selectedEditor.id;
                }
            }


            api.getNotices(accountId, criteria, function (result) {
                utils.applyScope($scope, function () {
                    // $scope.result.forEach(function (list) {
                    //     notices.getBasicUserInfo(list.user_id, function (info) {
                    //         utils.applyScope($scope, function () {
                    //             if(!Object.keys(result.author).length){
                    //
                    //             }
                    //             if ($scope.replies) {
                    //                 $scope.replies.forEach(function (rpl) {
                    //                     if (rpl.user_id == info.userId) {
                    //                         rpl.userName = info.displayName;
                    //                     }
                    //                     if (rpl.audit_user_id == info.userId) {
                    //                         rpl.auditorName = info.displayName;
                    //                     }
                    //                 });
                    //             }
                    //         });
                    //     });
                    // });
                    // if(!Object.keys(result.author).length){
                    //     notices.getBasicUserInfo(result.user_id, function (info) {
                    //         utils.applyScope($scope, function () {
                    //             if ($scope.replies) {
                    //                 $scope.replies.forEach(function (rpl) {
                    //                     if (rpl.user_id == info.userId) {
                    //                         rpl.userName = info.displayName;
                    //                     }
                    //                     if (rpl.audit_user_id == info.userId) {
                    //                         rpl.auditorName = info.displayName;
                    //                     }
                    //                 });
                    //             }
                    //         });
                    //     });
                    // }

                    if (!!isNew) {
                        $scope.historyNotices = result;
                    } else {
                        $scope.historyNotices = $scope.historyNotices.concat(result);
                    }
                    if ($scope.selectedAccount.category == 'task') {
                        var noticeIds = result.map(function (notice) {
                            return notice.id;
                        });
                        $scope.getPreAuditCount(noticeIds);
                    }
                    $scope.selectedNotices = $scope.historyNotices;
                    $scope.isLoadingNotice = false;
                });
            }, function (msg) {
                utils.applyScope($scope, function () {
                    $scope.isLoadingNotice = false;
                });
            });
        }
    };

    $scope.toggleNoticeType = function (type) {
        $scope.toggleCategories();
        if (type !== undefined) {
            $scope.historyNoticesSelected = type;
        } else {
            $scope.historyNoticesSelected = !$scope.historyNoticesSelected;
        }

        //设置当前列表第一个广播为选择状态。
        if ($scope.historyNoticesSelected) {
            $scope.selectedCategory = translate.instant("notice.sent-message");
            $scope.selectedNotices = $scope.historyNotices;
        } else {
            $scope.selectedNotices = $scope.draftNotices;
            $scope.selectedCategory = translate.instant("notice.drafts");
        }
    };

    $scope.showDetail = function (n, e) {
        if ($scope.selectedNotice == n && (!n.id || n.category != 'task')) {
            $scope.closeDetail();
            return;
        }
        if (n.is_close) {
            return;
        }
        $scope.selectedNotice = n;

        if (n.id) {
            if ($scope.selectedAccount.category == 'bbs') {
                $scope.isShowDetail = true;
                api.getOneNotice(n.id, function (data) {
                    utils.applyScope($scope, function () {
                        var notice = notices.notice.create();
                        notices.notice.convertFromData(notice, data);
                        if ($scope.selectedNotice.id == notice.id) {
                            $scope.selectedNotice.unreadCount = notice.unreadCount;
                            $scope.selectedNotice.readCount = notice.readCount;
                        }
                        $scope.selectedNotices.forEach(function (n) {
                            if (n.id == notice.id) {
                                n.unreadCount = notice.unreadCount;
                                n.readCount = notice.readCount;
                            }
                        });
                    });
                }, function (msg) {
                    log.logInfo("failed to load notice " + $scope.notice.id + "'s detail:" + msg);
                });
                return;
            }
            if ($scope.selectedAccount.category == 'task') {
                var params = ['task_info.html?'];
                params.push('id=' + n.id);

                var url = params.join('');
                pages.openModalDialog(url, 'task info', 900, 670, $scope, {
                    modal: false,
                    caption: [{
                        left: 0,
                        top: 5,
                        width: 90,
                        height: 20
                    }, {
                        left: 150,
                        top: 5,
                        width: -100,
                        height: 40
                    }],
                    resizable: true,
                    refreshIfExist: true,
                    enableDrag: true,
                    showCloseButton: true,
                    showMinimalButton: true,
                    showFullScreenButton: true,
                    behaviorIfSCClose: 4,
                    macResolution: {width: 900, height: 670}
                });
                return;
            }
        }
        delete $scope.selectedNotice.elements;
        $scope.isShowDetail = true;
    };

    $scope.closeDetail = function () {
        if ($scope.isSendingNotice) {
            return;
        }
        $scope.isShowDetail = false;
        $scope.selectedNotice = null;
    };

    //下拉刷新
    $scope.onScrollDown = function () {
        if ($scope.historyNoticesSelected) {
            $scope.getNotices();
        }
    };

    $scope.showPublishScope = function (n) {
        if (n.sections && n.sections.length > 0) {
            $scope.scopes = n.sections;
        } else {
            $scope.scopes = [];
        }
        $scope.isShowScopesPanel = true;
    };

    $scope.hidePublishScope = function () {
        $scope.isShowScopesPanel = false;
        $scope.scopes = null;
    };

    $scope.needShowPublishScope = function (n) {
        if (n.sections.length != $scope.selectedAccount.sectionIDs.length) {
            return true;
        }

        //查找公告的发布范围与账号是否一致
        for (var i = 0; i < n.sections.length; i++) {
            var isFind = false;
            for (var j = 0; j < $scope.selectedAccount.sectionIDs.length; j++) {
                if ($scope.selectedAccount.sectionIDs[j].id === n.sections[i].id) {
                    isFind = true;
                    break;
                }
            }
            if (!isFind) {
                return true;
            }
        }
        return false;
    };


    //-------------------------------------------------------------------//

    //--------------------------------- 账号管理-------------------------------//

    $scope.toggleAccountsOptions = function () {
        $scope.isShowOptions = !$scope.isShowOptions;
    };

    $scope.updateSelectedAccount = function (e, account) {
        if (e) {
            e.preventDefault();
            e.stopPropagation();
        }
        if ($scope.selectedAccount == account) {
            return;
        }

        if ($scope.selectedAccount) {
            $scope.clearCriteria($scope.selectedAccount);
        }
        $scope.clearCache();
        $scope.toggleAccountsOptions();

        if (!!account) {
            account.category = account.category || 'bbs';
            if (account.category == 'bbs') {
                $scope.showTooltip = !notices.haveSeenVideoTooltip();
                $scope.tooltipMessage = translate.instant("notice.video-tooltip");
            }
            if (account.category == 'task') {
                $scope.showTooltip = !notices.haveSeenTaskUpdateTooltip();
                $scope.tooltipMessage = translate.instant("notice.task-update-tooltip");
            }
            account.categoryText = notices.getCategoryName(account.category);
            $scope.publishMessage = notices.getCategoryProperty('publishText', account.category);
            $scope.sentMessage = notices.getCategoryProperty('sentText', account.category);
            $scope.selectedAccount = account;

            $scope.selectedAccount.allEditors = [$scope.defaultEditor];
            $scope.selectedAccount.selectedEditor = account.allEditors[0];
            $scope.getAccountsEditors($scope.selectedAccount);
        }
    };


    $scope.toggleAccountsSelection = function (e) {
        $scope.showAccountsSelection = !$scope.showAccountsSelection;
    };

    var stopSelectedAccountWatch = $scope.$watch("selectedAccount", function (newV, oldV) {
        if (!!newV) {
            $scope.historyNoticesSelected = true;
            $scope.getNotices(true);
            $scope.onDraftUpdate();
        } else {
            $scope.selectedNotices = null;
        }
    });

    var stopWatchSelectedNotices = $scope.$watch("selectedNotices", function (newV, oldV) {
        if ($scope.accountsLoaded) {
            if (!$scope.selectedAccount) {
                $scope.showEmpty = true;
                return;
            }

            if (newV && newV.length == 0 && $scope.historyNoticesSelected) {
                $scope.showEmpty = true;
                if (($scope.selectedAccount.timeRange && $scope.selectedAccount.timeRange.value) || ($scope.selectedAccount.selectedEditor && $scope.selectedAccount.selectedEditor.id != -1)) {
                    $scope.isNoFilterResult = true;
                } else {
                    $scope.isNoFilterResult = false;
                }
                if ($scope.selectedAccount.searchText) {
                    $scope.isNoSearchResult = true;
                } else {
                    $scope.isNoSearchResult = false;
                }
            } else {
                $scope.showEmpty = false;
            }
        }
    });

    $scope.toggleCategories = function () {
        // if(event){
        //   event.stopPropagation();
        // }
        $scope.isShowCategories = !$scope.isShowCategories;
    };

    $scope.onInit = function () {
        $scope.isShowOptions = false;
        $scope.successMsg = translate.instant("notice.publish-success");
        $scope.module = "notice";
        //获取用户信息并存入localstorage
        $scope.currentUser = api.getCurrentUser();
        $scope.selectedAccount = null;
        $scope.historyNotices = [];
        $scope.accounts = [];
        // $scope.cacheNotices = {};
        pages.attachEventScope($scope.module, $scope);

        $scope.accountsLoaded = true;
        $scope.selectedNotices = null;
        $scope.updateSelectedAccount(null, notices.retrieveSelectedAccount());
        //获取最新草稿箱
        $scope.onDraftUpdate();
        $scope.historyNoticesSelected = true;
        $scope.selectedCategory = translate.instant("notice.sent-message");
        notices.retrieveLocalData($scope.currentUser.userId);
    };

    $scope.$on("Init", function () {
        $scope.onInit();
    });
    $scope.onTopClick = function (e) {
        $scope.showTooltip = false;
        if (!$(e.target).closest(".noticeItem ")[0] && !$(e.target).closest(".detailPanel")[0]) {
            $scope.closeDetail();
        }
        if (!$(e.target).closest(".accountsGrid")[0] && !$(e.target).closest(".accountsSelect")[0]) {
            $scope.showAccountsSelection = false;
        }
        if (!$(e.target).closest(".timeRanges")[0] && !$(e.target).closest(".selectedTimeRange")[0]) {
            $scope.showAccountTimeRange = false;
        }
        if (!$(e.target).closest(".categoryOptions")[0] && !$(e.target).closest(".selectedCategory")[0]) {
            $scope.showSelectedCategory = false;
        }
        if (!$(e.target).closest(".accountEditors")[0] && !$(e.target).closest(".selectedEditor")[0]) {
            $scope.showSelectedAccountEditors = false;
        }

    };
    $scope.openModalDialog = function (params) {
        pages.openModalDialog(params.url, params.eventName, params.width, params.height, $scope);
    };

    $scope.convertTime = function (source) {//将日期转化成视觉要求
        return notices.convertNoticeTime(source);
    };
    //--------------------- show preview  ----------------//
    $scope.showPreview = function (n, e) {
        if ($scope.isSendingNotice) {
            return;
        }
        if (e) {
            e.stopPropagation();
        }

        var params = ['preview.html?'];
        if (!params) {
            return;
        }
        if (n.id) {
            params.push('id=' + n.id);
            params.push('&accountName=' + encodeURIComponent($scope.selectedAccount.name));
            params.push('&forceAvatar=' + encodeURIComponent($scope.selectedAccount.avatar));
        } else {
            params.push('localId=' + n.localId);
            params.push('&accountName=' + encodeURIComponent($scope.selectedAccount.name));
            params.push('&createTime=' + utils.time2str(n.createTimestamp ? n.createTimestamp / 1000 : Date.now() / 1000));
        }
        var url = params.join('');
        pages.openModalDialog(url, 'preview', 760, 720, $scope, {
            modal: false,
            caption: [{
                left: 0,
                top: 5,
                width: 90,
                height: 20
            }, {
                left: 150,
                top: 5,
                width: -100,
                height: 40
            }],
            resizable: true,
            refreshIfExist: true,
            enableDrag: true,
            showCloseButton: true,
            showMinimalButton: true,
            showFullScreenButton: true,
            behaviorIfSCClose: 0,
            macResolution: {width: 760, height: 670}
        });
    };

    //-------------------------------------------------------------------------//

    //------------------------消息列表搜索 过滤  排序---------------------------//
    $scope.toggleAccountTimeRange = function (e) {
        // if (e) {
        //     e.stopPropagation();
        // }
        $scope.showAccountTimeRange = !$scope.showAccountTimeRange;
    };

    $scope.timeRanges = [{
        key: translate.instant("notice.time-range.week"),
        value: 1000 * 60 * 60 * 24 * 7 //最近一周
    }, {
        key: translate.instant("notice.time-range.month"),
        value: 1000 * 60 * 60 * 24 * 30 //最近30天
    }, {
        key: translate.instant("notice.time-range.all"),
        value: null //最近一周
    }];

    $scope.getAccountTimeRange = function (account) {
        return account ? (account.timeRange ? account.timeRange.key : $scope.timeRanges[$scope.timeRanges.length - 1].key) : $scope.timeRanges[$scope.timeRanges.length - 1].key;
    };

    $scope.onTimeRangeChanged = function (range, e) {
        if (e) {
            e.stopPropagation();
        }
        $scope.toggleAccountTimeRange();
        if ($scope.selectedAccount.timeRange != range) {
            $scope.selectedAccount.timeRange = range;
            $scope.clearCache();
            $scope.clearSearchText($scope.selectedAccount);
            $scope.historyNoticesSelected = true;
            $scope.getNotices(true);
        }
    };

    $scope.clearCache = function () {
        $scope.historyNotices = [];
    };

    $scope.defaultEditor = {
        id: -1,
        name: translate.instant("common.all")
    };

    $scope.categories = [{
        type: 'all',
        text: translate.instant("common.all")
    }].concat(notices.getSupportCategories('edit'));

    $scope.getCategoryText = function (type) {
        if (!type) {
            return '';
        }
        for (var i = 0; i < notices.categories.length; i++) {
            if (notices.categories[i].type == type) {
                return notices.categories[i].text;
            }
        }
        return '';
    };

    $scope.toggleSelectedCategory = function (e) {
        $scope.showSelectedCategory = !$scope.showSelectedCategory;
    };

    $scope.onSelectedCategoryChanged = function (category, e) {
        if (e) {
            e.stopPropagation();
        }
        $scope.toggleSelectedCategory(e);
        if ($scope.selectedAccount.category != category) {
            $scope.selectedAccount.category = category;
            $scope.clearCache();
            $scope.clearSearchText($scope.selectedAccount);
            $scope.historyNoticesSelected = true;
            $scope.getNotices(true);
        }
    };

    $scope.getSelectedCategory = function (account) {
        return account ? (account.category ? account.category.text : $scope.categories[0].text) : $scope.categories[0].text;
    };

    //获取账号的所有编辑（包括已取消权限的）
    $scope.getAccountsEditors = function (account) {
        api.getAccountAllEditors(account.id, function (result) {
            utils.applyScope($scope, function () {
                result.forEach(function (data) {
                    account.allEditors.push({
                        id: data.user_id,
                        name: data.display_name
                    });
                });
            });
        }, function (msg) {
            log.logInfo("get account " + account.id + " all editor error " + msg);
        });

    };

    $scope.toggleSelectedAccountEditor = function (e) {
        $scope.showSelectedAccountEditors = !$scope.showSelectedAccountEditors;
    };

    $scope.onSelectedEditorChanged = function (editor, e) {
        if (e) {
            e.stopPropagation();
        }
        $scope.toggleSelectedAccountEditor();
        if ($scope.selectedAccount.selectedEditor != editor) {
            $scope.selectedAccount.selectedEditor = editor;
            $scope.clearCache();
            $scope.clearSearchText($scope.selectedAccount);
            $scope.historyNoticesSelected = true;
            $scope.getNotices(true);
        }
    };

    $scope.clearCriteria = function (account) {
        if (account) {
            if (account.timeRange) {
                delete account.timeRange;
            }
            account.selectedEditor = $scope.defaultEditor;
            if (account.searchText) {
                account.searchText = "";
            }
        }
    };

    $scope.clearSearchText = function (account) {
        if (account.searchText) {
            account.searchText = "";
        }
    };

    $scope.onSearchNotice = function () {
        var searchText = $scope.selectedAccount.searchText;
        $scope.clearCriteria($scope.selectedAccount);
        $scope.selectedAccount.searchText = searchText;
        $scope.clearCache();
        $scope.historyNoticesSelected = true;
        $scope.getNotices(true);
    };

    $scope.getEmptyText = function () {
        return translate.instant(`notice.${$scope.selectedAccount.category}-empty`);
    }

    $scope.onSearchTextKeyUp = function (e) {
        if (e.keyCode == 13) {
            $scope.onSearchNotice();
        }
    };

    $scope.updateSearchFocusStatus = function (value) {
        $scope.searchFocused = value;
    };

    $scope.removeSearchText = function () {
        $scope.selectedAccount.searchText = "";
        $scope.onSearchNotice();
    };

    $scope.manage = function () {
        utils.saveObjTolocalStorage(notices.MANAGEMENT_ACCOUNT_KEY, $scope.selectedAccount);
        $location.path('/manage');
    };

    //------------------------------------评论 --------------------------------//
    $scope.convertBadgeNumber = function (num) {
        return utils.convertBadgeNumber(num);
    };
    $scope.updateCommentCount = function (commentInfo) {
        if ($scope.historyNoticesSelected) {
            var index = $scope.selectedNotices.findIndex(function (notice) {
                return notice.id == commentInfo.noticeId;
            });
            if (index > 0) {
                utils.applyScope($scope, function () {
                    $scope.selectedNotices[index].commentCount = commentInfo.commentCount;
                });
            }
        }
    };


    //-------------------------------公告板修改 删除 更新事件 -------------------//
    var offBoardEdit = $scope.$on("board_edit", function (e, data) {
        log.logInfo("notice controller receive account edit event:" + JSON.stringify(data));
        utils.applyScope($scope, function () {
            if ($scope.selectedAccount && $scope.selectedAccount.id == data.board_id) {
                var ac = notices.account();
                ac.convertFromData(data);
                $scope.selectedAccount.avatar = ac.avatar;
                $scope.selectedAccount.name = ac.name;
            }
            var storeAccount = notices.retrieveSelectedAccount();
            if (storeAccount && storeAccount.id == data.board_id) {
                notices.saveSelectedAccount($scope.selectedAccount);
                pages.fnCall("publishWindow", "editAccount", $scope.selectedAccount, function () {
                });
            }
        });
    });

    var offBoardUpdate = $scope.$on("board_update", function (e, data) {
        log.logInfo("notice controller receive account update event:" + JSON.stringify(data));
        utils.applyScope($scope, function () {
            var currentUser = utils.retrieveUser();
            var uIndex = data.editor_info.findIndex(function (user) {
                return user.user_id == currentUser.userId;
            });
            if (uIndex < 0) {
                $scope.removeAccounts(data, "common.no-account-right-alert");
            } else {
                var ac = notices.account();
                ac.convertFromData(data);

                if ($scope.selectedAccount && data.board_id == $scope.selectedAccount.id) {
                    $scope.selectedAccount.sectionIDs = ac.sectionIDs;
                    $scope.selectedAccount.editors = ac.editors;
                }
                var storeAccount = notices.retrieveSelectedAccount();
                if (storeAccount && storeAccount.id == data.board_id) {
                    notices.saveSelectedAccount(ac);
                    pages.fnCall("publishWindow", "updateAccount", ac, function () {
                    });
                }
            }
        });
    });

    var offBoardDelete = $scope.$on("board_destroy", function (e, data) {
        log.logInfo("notice controller receive account delete event:" + JSON.stringify(data));
        $scope.removeAccounts(data, "common.account-delete-alert");
    });

    //-----------------------------任务消息-----------------------------------//
    var offTaskReplyUpdate = $scope.$on("task_reply_update", function (e, data) {
        if (data.board_id == $scope.selectedAccount.id) {
            $scope.getPreAuditCount([data.bbs_id]);
        }
    });

    $scope.removeAccounts = function (data, message) {
        if ($scope.selectedAccount && $scope.selectedAccount.id == data.board_id) {
            $scope.backToMain();
        }
        var storeAccount = notices.retrieveSelectedAccount();
        if (storeAccount.id == data.board_id) {
            pages.fnCall("publishWindow", "onAccountInvalid", translate.instant(message, {name: storeAccount.name}), function () {
            });
        }
    };

    $scope.$on("$destroy", function () {
        stopWatchSelectedNotices();
        stopSelectedAccountWatch();
        offBoardEdit();
        offBoardUpdate();
        offBoardDelete();
        offTaskReplyUpdate();
        pages.detachEventScope($scope.module);
    });
    $scope.onInit();
}]);
